/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core.tunneling;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.php.debug.PHPDebugPlugin;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.core.IJSchService;

public class SSHTunnelSession {
    private static final int DEFAULT_TIMEOUT = 45000;
    private static Map<String, SSHTunnelSession> pool = new HashMap<String, SSHTunnelSession>();
    private Session session;

    public static SSHTunnelSession getSession(String username, String password, String hostname, int port, IProgressMonitor monitor) throws JSchException {
        String key = SSHTunnelSession.getPoolKey(username, hostname, port);
        try {
            SSHTunnelSession jschSession = pool.get(key);
            if (jschSession != null && !jschSession.getSession().isConnected()) {
                pool.remove(key);
                jschSession = null;
            }
            if (jschSession == null) {
                IJSchService service = SSHTunnelSession.getJSchService();
                IJSchLocation jlocation = service.getLocation(username, hostname, port);
                Session session = null;
                session = SSHTunnelSession.createSession(service, jlocation, password, monitor);
                if (session == null) {
                    throw new JSchException("Could not create a debug tunneling session to " + hostname);
                }
                if (session.getTimeout() != 45000) {
                    session.setTimeout(45000);
                }
                SSHTunnelSession schSession = new SSHTunnelSession(session);
                pool.put(key, schSession);
                return schSession;
            }
            return jschSession;
        }
        catch (JSchException e) {
            pool.remove(key);
            if (e.toString().indexOf("Auth cancel") != -1) {
                throw new OperationCanceledException("SSH Tunnel Session: Authentication Canceled");
            }
            throw e;
        }
    }

    private static Session createSession(IJSchService service, IJSchLocation location, String password, IProgressMonitor monitor) throws JSchException {
        Session session = service.createSession(location, null);
        session.setTimeout(45000);
        if (password != null) {
            session.setPassword(password);
        }
        service.connect(session, 45000, monitor);
        return session;
    }

    private static IJSchService getJSchService() {
        return PHPDebugPlugin.getDefault().getJSchService();
    }

    private static String getPoolKey(String username, String hostname, int port) {
        return MessageFormat.format("{0}@{1}:{2}", username, hostname, port);
    }

    public static void shutdown() {
        if (SSHTunnelSession.getJSch() != null && !CollectionsUtil.isEmpty(pool)) {
            for (SSHTunnelSession session : pool.values()) {
                try {
                    session.getSession().disconnect();
                }
                catch (Exception exception) {}
            }
            pool.clear();
        }
    }

    public static JSch getJSch() {
        return SSHTunnelSession.getJSchService().getJSch();
    }

    private SSHTunnelSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void dispose() {
        pool.remove(SSHTunnelSession.getPoolKey(this.session.getUserName(), this.session.getHost(), this.session.getPort()));
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
    }
}

